﻿      function rokPrzestepny(rok)
      {
        return ((rok % 4 == 0) && ((rok % 100 != 0) || (rok % 400 == 0)));
      }
      function wyświetlKalendarz(r, m, d, el)
      {
        var data = new Date(r, m, d);
        if(data == "Invalid date") data = new Date();
        
        var rok = data.getFullYear();
        var miesiac = data.getMonth() + 1;
        var dzienTygodnia = data.getDay();
        var dzienMiesiaca = data.getDate();

        var tempDate = new Date(rok, miesiac - 1, 1);
        var pierwszyDzienMiesiaca = tempDate.getDay();

        if(dzienTygodnia == 0) dzienTygodnia = 7;
        if(pierwszyDzienMiesiaca == 0) pierwszyDzienMiesiaca = 7;

        switch(miesiac){
          case 1 : nazwaMiesiaca = "Styczeń";
                   dniWMiesiacu = 31;
                   break;
          case 2 : nazwaMiesiaca = "Luty";
                   dniWMiesiacu = rokPrzestepny(rok)?29:28;
                   break;
          case 3 : nazwaMiesiaca = "Marzec";
                   dniWMiesiacu = 31;
                   break;
          case 4 : nazwaMiesiaca = "Kwiecień";
                   dniWMiesiacu = 30;
                   break;
          case 5 : nazwaMiesiaca = "Maj";
                   dniWMiesiacu = 31;
                   break;
          case 6 : nazwaMiesiaca = "Czerwiec";
                   dniWMiesiacu = 30;
                   break;
          case 7 : nazwaMiesiaca = "Lipiec";
                   dniWMiesiacu = 31;
                   break;
          case 8 : nazwaMiesiaca = "Sierpień";
                   dniWMiesiacu = 31;
                   break;
          case 9 : nazwaMiesiaca = "Wrzesień";
                   dniWMiesiacu = 30;
                   break;
          case 10 : nazwaMiesiaca = "Październik";
                   dniWMiesiacu = 31;
                   break;
          case 11 : nazwaMiesiaca = "Listopad";
                   dniWMiesiacu = 30;
                   break;
          case 12 : nazwaMiesiaca = "Grudzień";
                   dniWMiesiacu = 31;
                   break;
        }
        
        var str = "";

        str += "<table border='1'><tr>";
        str += "<td class='tdNaglowek' colspan='7'>";
        str += "<span class='clickable' onclick='wyświetlKalendarz(";
        str += rok + "," + (miesiac - 2) + "," + dzienMiesiaca + ",\"";
        str += el + "\");'>&lt;&lt;<\/span>&nbsp;&nbsp;";
        str += nazwaMiesiaca + " " + rok + "&nbsp;&nbsp;";
        str += "<span class='clickable' onclick='wyświetlKalendarz(";
        str += rok + "," + (miesiac) + "," + dzienMiesiaca + ",\"";
        str += el + "\");'>&gt;&gt;<\/span>";
        str += "<\/td><\/tr>";

        str += "<tr class='trNazwyDni'>";
        str += "<td>Pn<\/td>";
        str += "<td>Wt<\/td>";
        str += "<td>Śr<\/td>";
        str += "<td>Cz<\/td>";
        str += "<td>Pi<\/td>";
        str += "<td>So<\/td>";
        str += "<td>Nd<\/td>";
        str += "<\/tr><tr>";

        var j = dniWMiesiacu + pierwszyDzienMiesiaca - 1;

        for(var i = 0; i < j; i++){
          if(i < pierwszyDzienMiesiaca - 1){
            str += "<td class='tdEmpty'><\/td>";
            continue;
          }
          if((i % 7) == 0){
            str += "<\/tr><tr>";
          }
          var klasa = "tdDzien";
          var dzien = i - pierwszyDzienMiesiaca + 2;
          if(dzien == dzienMiesiaca && 
             (new Date()).toDateString() == data.toDateString()){
            klasa = "tdBiezacyDzien";
          }
          str += "<td class='" + klasa + "' onclick='ustawDate(";
          str += rok + "," + miesiac + "," + dzien + ");";
          str += "schowajWarstwę(\"divKalendarz\");'>"
          str += dzien;
          str += "<\/td>";
        }
        str += "<\/tr><\/table>";
        
        var el = document.getElementById(el);
        if(el) el.innerHTML = str;
      }
      function ustawDate(r, m, d)
      {
        var tfData = document.getElementById('tfData');
        if(tfData){
          m = m < 10 ? "0" + m : "" + m;
          d = d < 10 ? "0" + d : "" + d;
          tfData.value = r + "/" + m + "/" + d;
        }
      }
      function pokażWarstwę(obj, nazwa)
      {
        if(!obj) return;
        var div = document.getElementById(nazwa);
        if(!div) return;

        var xOff = obj.offsetWidth/1;
        var yOff = obj.offsetHeight/1;

        while(obj.offsetParent){
          xOff += obj.offsetLeft/1;
          yOff += obj.offsetTop/1;
          obj = obj.offsetParent;
        }

        div.style.top = yOff + "px";
        div.style.left = xOff + "px";
        div.style.display = "block";
      }

      function schowajWarstwę(nazwa)
      {
        var div = document.getElementById(nazwa);
        if(div)
          div.style.display = "none";
      }